package ru.yandex.chemodan.app.notifier.actions;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.convert.ConverterToDataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.binders.OptionalDataApiUserIdBinder;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author buberman
 */
@Path(value = "/mark-as-read", methods = {HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT})
@RequiredArgsConstructor
public class MarkNotificaionBlockRead implements CloneableAction {
    @BindWith(OptionalDataApiUserIdBinder.class)
    private Option<DataApiUserId> user;
    @RequestParam(value = "ownerUid", customConverter = ConverterToDataApiUserId.class)
    private Option<DataApiUserId> owner;

    @RequestParam
    private String service;
    @RequestParam
    private String groupKey;

    @RequestParam
    private String recordType;

    private final NotificationManager notificationManager;
    private final NotificationRecordTypeManager notificationRecordTypeManager;

    @Override
    public Object execute() {
        DataApiUserId uid = user.getOrElse(owner.getOrThrow("Neither user nor owner were specified"));

        notificationManager.markMessageAsRead(
                uid, groupKey, notificationRecordTypeManager.resolveRecordType(recordType, service));
        return new OkPojo();
    }
}
