package ru.yandex.chemodan.app.notifier.actions;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.auth.FromQueryParamsInterceptor;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.app.notifier.NotificationBaseContextConfiguration;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.grants.ServiceGrantsChecker;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.push.NotificationPushManager;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.notifier.GetUnreadNotificationsCountAction;
import ru.yandex.chemodan.notifier.NotifierUnreadCountProvider;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ProtobufResultSerializer;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author buberman
 */
@Configuration
@Import({
    NotificationBaseContextConfiguration.class,
})
public class NotificationActionsContextConfiguration {
    @Bean
    public ActionApp actionApp(
            ApplicationContext context,
            ApplicationInfo applicationInfo)
    {
        BenderMapper benderMapper = DataApiBenderUtils.mapper();

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator
                .addJsonBending(benderMapper).getBuilder()

                .addParameterBinders(Cf.list(
                        new DataApiUserIdBinder()))

                .addResultSerializers(Cf.list(
                        new ProtobufResultSerializer()))

                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo)))

                .addDispatcherInterceptors(Cf.list(
                        new FromQueryParamsInterceptor()))
        ;

        return configurator.configure();
    }

    @Bean
    public AddNotificationAction addNotificationAction(
            NotificationManager notificationManager,
            NotificationRecordTypeManager notificationRecordTypeManager,
            ServiceGrantsChecker serviceGrantsChecker)
    {
        return new AddNotificationAction(notificationManager, notificationRecordTypeManager, serviceGrantsChecker);
    }

    @Bean
    public SendUpgradeNotificationPushAction sendUpgradeNotificationPushAction(
            NotificationPushManager notificationPushManager,
            NotificationRecordTypeManager typeManager,
            PgBazingaStorage bazingaStorage)
    {
        return new SendUpgradeNotificationPushAction(notificationPushManager, typeManager, bazingaStorage);
    }

    @Bean
    public DisableResourceNotificationsAction unsubscribeFromResourceAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new DisableResourceNotificationsAction(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Bean
    public EnableResourceNotificationsAction resubscribeToResourceAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new EnableResourceNotificationsAction(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Bean
    public CheckResourceSubscriptionAction checkResourceSubscriptionAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new CheckResourceSubscriptionAction(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Bean
    public GetAllUnsubscribedResourcesAction getAllUnsubscribedResourcesAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new GetAllUnsubscribedResourcesAction(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Bean
    public GetResourceNotificationsSettingsAction getResourceNotificationsSettingsAction(
            NotificationsSettingsManager notificationsSettingsManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new GetResourceNotificationsSettingsAction(notificationsSettingsManager, notificationRecordTypeManager);
    }

    @Bean
    public MarkNotificaionBlockRead markNotificaionBlockRead(
            NotificationManager notificationManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new MarkNotificaionBlockRead(notificationManager, notificationRecordTypeManager);
    }

    @Bean
    public GetUnreadNotificationsCountAction getUnreadNotificationsCountAction(
            NotifierUnreadCountProvider unreadCountProvider)
    {
        return new GetUnreadNotificationsCountAction(unreadCountProvider);
    }

    @Bean
    public DeleteNotificationAction deleteNotificationAction(
            NotificationManager notificationManager,
            NotificationRecordTypeManager notificationRecordTypeManager)
    {
        return new DeleteNotificationAction(notificationManager, notificationRecordTypeManager);
    }

    @Bean
    public ServiceGrantsChecker serviceGrantsChecker(@Value("${notifier.check.app.grants}") boolean enabled) {
        return new ServiceGrantsChecker(enabled);
    }
}
