package ru.yandex.chemodan.app.notifier.actions;

import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.convert.ConverterToDataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.binders.OptionalDataApiUserIdBinder;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskServices;
import ru.yandex.chemodan.app.notifier.settings.NotificationsSettingsManager;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

/**
 * @author akirakozov
 */
@RequiredArgsConstructor
public abstract class ResourceSubscriptionBaseAction implements CloneableAction {
    @BindWith(OptionalDataApiUserIdBinder.class)
    protected Option<DataApiUserId> user;
    @RequestParam(value = "ownerUid", customConverter = ConverterToDataApiUserId.class)
    protected Option<DataApiUserId> owner;
    @RequestParam
    private Option<String> service;

    protected final NotificationsSettingsManager notificationsSettingsManager;
    protected final NotificationRecordTypeManager notificationRecordTypeManager;

    public String getService() {
        return service.getOrElse(DiskServices.DISK);
    }

    protected DataApiUserId getSubscriberUid() {
        return user.getOrElse(owner.getOrThrow("Neither user nor owner were specified"));
    }
}
