package ru.yandex.chemodan.app.notifier.actions;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.push.NotificationPushManager;
import ru.yandex.commune.bazinga.impl.OnetimeJob;
import ru.yandex.commune.bazinga.pg.storage.JobSaveResult;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

public class SendUpgradeNotificationPushActionTest {

    private final PgBazingaStorage pgBazingaStorage = mock(PgBazingaStorage.class);
    private final NotificationPushManager notificationPushManager = mock(NotificationPushManager.class);
    private final NotificationRecordTypeManager notificationRecordTypeManager = mock(NotificationRecordTypeManager.class);
    private final SendUpgradeNotificationPushAction action = new SendUpgradeNotificationPushAction(
            notificationPushManager,
            notificationRecordTypeManager,
            pgBazingaStorage);

    @Before
    public void prepare() {
        Mockito.reset(notificationPushManager);

        setValue(action, "uid", DataApiUserId.parse("123"));
        setValue(action, "deviceId", Option.of("deviceId"));
        setValue(action, "os", Option.of("android"));
        setValue(action, "direct", Option.empty());
        when(notificationRecordTypeManager.resolveRecordType(any()))
                .thenReturn(mock(NotificationType.class));
    }

    @Test
    public void testSkipExecutionByBazingaFilter() throws Exception {

        mergedEvent(true);
        action.execute();
        verifyResult(never());
    }

    @Test
    public void testExecute() throws Exception {

        mergedEvent(false);
        action.execute();
        verifyResult(atLeastOnce());
    }

    private void verifyResult(VerificationMode mode) {
        verify(notificationPushManager, mode).pushNotification(any(), any(), any(), any());
    }

    private void mergedEvent(boolean result) {
        JobSaveResult.Merged onetimeJob = mock(JobSaveResult.Merged.class);
        when(onetimeJob.isMerged()).thenReturn(result);
        when(pgBazingaStorage.addOnetimeJobX(any(OnetimeJob.class), eq(ActiveUidDuplicateBehavior.DO_NOTHING)))
                .thenReturn(onetimeJob);
    }

    private void setValue(SendUpgradeNotificationPushAction action, String field, Object value) {
        FieldX f = ClassX.wrap(SendUpgradeNotificationPushAction.class).getDeclaredField(field);
        f.setAccessible(true);
        f.set(action, value);
    }
}
