package ru.yandex.chemodan.app.notifier.admin;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author akirakozov
 */
@BenderBindAllFields
public class NotifierTypesData {
    private static BenderParserSerializer<NotifierTypesData> bender = BenderParserSerializer.cons(
            ClassX.wrap(NotifierTypesData.class),
            DataApiBenderUtils.getConfig());

    public final ListF<NotificationType> types;
    public final ListF<NotificationGroup> groups;

    public NotifierTypesData(ListF<NotificationType> types, ListF<NotificationGroup> groups) {
        this.types = types;
        this.groups = groups;
    }

    public byte[] toJson() {
        return bender.getSerializer().serializeJson(this);
    }

    public static NotifierTypesData fromJson(String json) {
        return bender.getParser().parseJson(json);
    }

}
