package ru.yandex.chemodan.app.notifier.admin;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

import ru.yandex.chemodan.app.notifier.admin.dao.test.ActivateNotificationEmbeddedPg;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationTypeManagerTestContextConfiguration;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskServices;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
@ActivateNotificationEmbeddedPg
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = NotificationTypeManagerTestContextConfiguration.class)
@TestExecutionListeners(value = DependencyInjectionTestExecutionListener.class)
public class NotifierTypesDataTest {

    @Autowired
    private NotificationRecordTypeManager typeManager;

    @Test
    public void serializeParseTest() {
        NotifierTypesData typesData = new NotifierTypesData(
                typeManager.getRecordTypes(), typeManager.getNotificationGroups(DiskServices.DISK));

        NotifierTypesData parsedTypesData = NotifierTypesData.fromJson(new String(typesData.toJson()));
        Assert.equals(typesData.groups, parsedTypesData.groups);
        Assert.equals(typesData.types.size(), parsedTypesData.types.size());
    }

}
