package ru.yandex.chemodan.app.notifier.admin;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.chemodan.app.notifier.notification.NotificationService;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;

/**
 * @author akirakozov
 */
public class NotifierTypesRegistry {
    private final NotificationRecordTypeJdbcDao typesDao;
    private final NotificationGroupJdbcDao groupDao;
    private final NotificationServiceJdbcDao serviceDao;
    private final Function0V onWriteCallback;

    public NotifierTypesRegistry(
            NotificationRecordTypeJdbcDao typesDao, NotificationGroupJdbcDao groupDao,
            NotificationServiceJdbcDao serviceDao, Function0V onWriteCallback)
    {
        this.typesDao = typesDao;
        this.groupDao = groupDao;
        this.serviceDao = serviceDao;
        this.onWriteCallback = onWriteCallback;
    }

    public ListF<NotificationService> getAllServices() {
        return serviceDao.findAll();
    }

    public ListF<NotificationType> getAllTypes() {
        return typesDao.findAll();
    }

    public ListF<NotificationGroup> getAllGroups() {
        return groupDao.findAll();
    }

    public NotificationService getServiceById(int serviceId) {
        return serviceDao.findById(serviceId).get();
    }

    public NotificationType getTypeById(int typeId) {
        return typesDao.findById(typeId).get();
    }

    public NotificationGroup getGroupById(int groupId) {
        return groupDao.findById(groupId).get();
    }

    public ListF<NotificationGroup> getGroupsByServiceId(int serviceId) {
        return groupDao.findByServiceId(serviceId);
    }

    public ListF<NotificationType> getTypesByServiceId(int serviceId) {
        return typesDao.findByServiceId(serviceId);
    }

    public ListF<NotificationType> getTypesByGroupId(int groupId) {
        return typesDao.findByGroupId(groupId);
    }

    public void saveType(NotificationType notificationType) {
        if (notificationType.id.isPresent()) {
            typesDao.update(notificationType);
        } else {
            typesDao.insert(notificationType);
        }
        onWriteCallback.apply();
    }

    public void saveGroup(NotificationGroup group) {
        if (group.id.isPresent()) {
            groupDao.update(group);
        } else {
            groupDao.insert(group);
        }
        onWriteCallback.apply();
    }

    public void saveService(NotificationService service) {
        if (service.id.isPresent()) {
            serviceDao.update(service);
        } else {
            serviceDao.insert(service);
        }
        onWriteCallback.apply();
    }

}
