package ru.yandex.chemodan.app.notifier.admin;

import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.chemodan.app.notifier.notification.NotificationIcon;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationService;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.notification.NotifierTypesLoader;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.when;

/**
 * @author akirakozov
 */
public class NotifierTypesRegistryTest {

    private NotifierTypesRegistry registry;
    private NotificationRecordTypeManager manager;

    @Mock
    private NotificationRecordTypeJdbcDao typeJdbcDao;
    @Mock
    private NotificationGroupJdbcDao groupJdbcDao;
    @Mock
    private NotificationServiceJdbcDao serviceJdbcDao;
    @Mock
    private NotifierTypesLoader notifierTypesLoader;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);

        manager = new NotificationRecordTypeManager(notifierTypesLoader, Option.empty());
        registry = new NotifierTypesRegistry(typeJdbcDao, groupJdbcDao, serviceJdbcDao,
                () -> manager.refreshCashedTypesData());

    }

    @Test
    public void autoRefreshOnStoreData() {
        NotificationType type = createType(1, 3);
        when(notifierTypesLoader.loadFilledRecordTypes())
                .thenReturn(new NotifierTypesData(Cf.list(type), Cf.list(type.getGroup())));

        Assert.isEmpty(manager.getRecordTypes(), "No types should be created before store");

        registry.saveType(type);

        NotificationType foundType = manager
                .getRecordTypes()
                .filter(t -> t.name.equals(type.name)).single();

        Assert.equals(type, foundType);
    }

    private NotificationType createType(int id, int groupId) {
        return new NotificationType(
                id, groupId, "name_" + id, NotificationIcon.DEFAULT,
                "msg_" + id, "msg_title_" + id, "msg_short_id", Option.empty(),
                CounterConfiguration.NONE, MetadataWrapper.createEmpty(), Duration.ZERO, Cf.list())
                .withGroup(createGroup(groupId).withService(new NotificationService(Option.empty(),"service", "keyset", false)));
    }

    private NotificationGroup createGroup(int id) {
        return new NotificationGroup(id, 1, "group_name_" + id, Option.empty(), Option.empty());
    }

}
