package ru.yandex.chemodan.app.notifier.admin;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.app.dataapi.utils.DataApiZkRegistry;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author akirakozov
 */
public class NotifierTypesZkLastUpdateWatcher
        extends DataApiZkRegistry<NotifierTypesZkLastUpdateWatcher.LastUpdate>
{
    private final NotificationRecordTypeManager typeManager;

    public NotifierTypesZkLastUpdateWatcher(ZkPath zkPath, NotificationRecordTypeManager typeManager) {
        super(zkPath, LastUpdate.class, s -> "last_update", ZkPathEscaping.asIs);
        this.typeManager = typeManager;
    }

    @Override
    protected void handleNewState(CollectionF<LastUpdate> allElements) {
        typeManager.refreshCashedTypesData();
    }

    public void onWrite() {
        put(new LastUpdate(Instant.now()));
    }

    @BenderBindAllFields
    public static class LastUpdate {
        public final Instant time;

        public LastUpdate(Instant time) {
            this.time = time;
        }
    }
}
