package ru.yandex.chemodan.app.notifier.admin.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.notifier.admin.dao.mapper.RowMarshaller;
import ru.yandex.chemodan.app.notifier.admin.dao.test.NotificationJdbcDaoTestSupport;
import ru.yandex.chemodan.util.postgres.PgSqlQueryUtils;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlQuery;
import ru.yandex.misc.db.q.SqlQueryUtils;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author akirakozov
 */
public abstract class NotificationBaseJdbcDao<T> extends NotificationJdbcDaoTestSupport {
    protected final RowMarshaller<T> marshaller;
    private final String tableName;

    protected final JdbcTemplate3 jdbcTemplate;


    public NotificationBaseJdbcDao(JdbcTemplate3 jdbcTemplate,
            RowMarshaller<T> marshaller, String tableName)
    {
        this.jdbcTemplate = jdbcTemplate;
        this.marshaller = marshaller;
        this.tableName = tableName;
    }

    @RunWithRandomTest
    public ListF<T> findAll() {
        return jdbcTemplate.query("SELECT * FROM " + getQuotedTableName(), marshaller);
    }

    @RunWithRandomTest
    public Option<T> findById(long id) {
        return jdbcTemplate.query("SELECT * FROM " + getQuotedTableName() + " WHERE id = ?", marshaller, id)
                .singleO();
    }

    @RunWithRandomTest
    public long deleteById(long id) {
        return jdbcTemplate.update("DELETE FROM " + getQuotedTableName() + " WHERE id = ?", id);
    }

    // TODO: fix @RunWithRandomTest for generic types
    //@RunWithRandomTest(possible = DataIntegrityViolationException.class)
    public int insert(T bean) {
        SqlQuery query = PgSqlQueryUtils.insertIgnoreQuery(
                getQuotedTableName(), marshaller.asColumnsValues(bean));

        return jdbcTemplate.queryForInt(query.sql() + " RETURNING id", query.args());
    }

    public void update(T bean) {
        Tuple2List<String, Object> allValues = marshaller.asColumnsValues(bean);
        Tuple2List<String, Object> values = allValues.filterBy1Not(v -> v.equals("id"));
        int idValue = (Integer) allValues.filterBy1(v -> v.equals("id")).single().get2();
        SqlQuery query = SqlQueryUtils.updateQuery(
                getQuotedTableName(), values, SqlCondition.column("id").eq(idValue));

        jdbcTemplate.update(query.sql(), query.args());
    }

    protected String getQuotedTableName() {
        return "\"" + tableName + "\"";
    }
}
