package ru.yandex.chemodan.app.notifier.admin.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.admin.dao.mapper.NotificationGroupMarshaller;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author akirakozov
 */
public class NotificationGroupJdbcDao extends NotificationBaseJdbcDao<NotificationGroup> {

    public NotificationGroupJdbcDao(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate, new NotificationGroupMarshaller(), "group");
    }

    @RunWithRandomTest
    public ListF<NotificationGroup> findByServiceId(long serviceId) {
        return jdbcTemplate.query(
                    "SELECT * FROM " + getQuotedTableName() + " WHERE service_id = ?",
                    marshaller, serviceId);
    }

}
