package ru.yandex.chemodan.app.notifier.admin.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.admin.dao.mapper.NotificationRecordTypeMarshaller;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author akirakozov
 */
public class NotificationRecordTypeJdbcDao extends NotificationBaseJdbcDao<NotificationType> {

    public NotificationRecordTypeJdbcDao(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate, new NotificationRecordTypeMarshaller(), "type");
    }

    @RunWithRandomTest
    public ListF<NotificationType> findByServiceId(long serviceId) {
        return jdbcTemplate.query(
                "SELECT * FROM " + getQuotedTableName() +
                        "INNER JOIN \"group\" on \"type\".group_id = \"group\".id " +
                        "WHERE \"group\".service_id = ?",
                marshaller, serviceId);
    }

    @RunWithRandomTest
    public ListF<NotificationType> findByGroupId(long groupId) {
        return jdbcTemplate.query(
                "SELECT * FROM " + getQuotedTableName() + "WHERE group_id = ?",
                marshaller, groupId);
    }
}
