package ru.yandex.chemodan.app.notifier.admin.dao;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.dao.test.ActivateNotificationEmbeddedPg;
import ru.yandex.chemodan.app.notifier.admin.dao.test.NotifierJdbcDaoTestsContextConfiguration;
import ru.yandex.chemodan.app.notifier.notification.NotificationService;
import ru.yandex.chemodan.test.TestHelper;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.test.TestBase;

/**
 * @author akirakozov
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        NotifierJdbcDaoTestsContextConfiguration.class
})
@ActivateNotificationEmbeddedPg
public class NotificationServiceJdbcDaoTest extends TestBase {

    @Autowired
    private NotificationServiceJdbcDao notificationServiceJdbcDao;

    @Before
    public void init() {
        TestHelper.initialize();
    }

    @Test
    public void createFindUpdate() throws Exception {
        String prefix = "_" + Random2.R.nextAlnum(10);
        NotificationService notificationService =
                new NotificationService(Option.empty(), "test_service" + prefix, "tanker_key", false);

        try {
            int createdId = notificationServiceJdbcDao.insert(notificationService);
            notificationService = notificationService.withId(createdId);
            NotificationService ns = notificationServiceJdbcDao.findById(createdId).get();

            Assert.equals(notificationService, ns);

            String newName = ns.name + "_new";
            String newTankerKey = "new_key";
            ns = new NotificationService(ns.id.get(), newName, newTankerKey, false);
            notificationServiceJdbcDao.update(ns);

            ns = notificationServiceJdbcDao.findById(createdId).get();
            Assert.equals(newName, ns.name);
            Assert.equals(newTankerKey, ns.tankerKeysetId);
        } finally {
            notificationService.id.forEach(notificationServiceJdbcDao::deleteById);
        }
    }

}
