package ru.yandex.chemodan.app.notifier.admin.dao;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author akirakozov
 */
@Configuration
@Import(JdbcDatabaseConfiguratorContextConfiguration.class)
public class NotifierAdminJdbcContextConfiguration {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    public NotificationServiceJdbcDao notificationServiceJdbcDao(JdbcTemplate3 notifierAdminJdbcTemplate) {
        return new NotificationServiceJdbcDao(notifierAdminJdbcTemplate);
    }

    @Bean
    public NotificationGroupJdbcDao notificationGroupJdbcDao(JdbcTemplate3 notifierAdminJdbcTemplate) {
        return new NotificationGroupJdbcDao(notifierAdminJdbcTemplate);
    }

    @Bean
    public NotificationRecordTypeJdbcDao notificationRecordTypeJdbcDao(JdbcTemplate3 notifierAdminJdbcTemplate) {
        return new NotificationRecordTypeJdbcDao(notifierAdminJdbcTemplate);
    }

    @Bean
    public JdbcDatabaseConfigurator notifierAdminDbConfigurator(DataSourceProperties notifierAdminDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(notifierAdminDataSourceProperties);
    }

    @Bean
    public DataSource notifierAdminDataSource(JdbcDatabaseConfigurator notifierAdminDbConfigurator) {
        return notifierAdminDbConfigurator.configureDataSource();
    }

    @Bean
    public JdbcTemplate3 notifierAdminJdbcTemplate(
            JdbcDatabaseConfigurator notifierAdminDbConfigurator, DataSource notifierAdminDataSource)
    {
        return notifierAdminDbConfigurator.consTemplate(notifierAdminDataSource);
    }

}
