package ru.yandex.chemodan.app.notifier.admin.dao;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author vpronto
 */
@Configuration
@Import(NotifierAdminJdbcContextConfiguration.class)
@ConditionalOnMissingEmbeddedDb
public class NotifierDataSourcePropertiesConfiguration {

    @Bean
    @OverridableValuePrefix("notifier-admin")
    public DataSourceProperties notifierAdminDataSourceProperties() {
        return new DataSourceProperties();
    }

}
