package ru.yandex.chemodan.app.notifier.admin.dao.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.notifier.notification.NotificationGroup;

/**
 * @author akirakozov
 */
public class NotificationGroupMarshaller implements RowMarshaller<NotificationGroup> {
    @Override
    public NotificationGroup mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new NotificationGroup(
                rs.getInt("id"),
                rs.getInt("service_id"),
                rs.getString("name"),
                Option.ofNullable(rs.getString("description")),
                Option.ofNullable(rs.getString("settings_group_name")));
    }

    public Tuple2List<String, Object> asColumnsValues(NotificationGroup group) {
        Tuple2List<String, Object> res = Tuple2List.arrayList();

        group.id.forEach(id -> res.add("id", id));
        group.service_id.forEach(id -> res.add("service_id", id));
        res.add("name", group.name);
        group.description.forEach(d -> res.add("description", d));
        group.settingsGroupName.forEach(d -> res.add("settings_group_name", d));

        return res;
    }

}
