package ru.yandex.chemodan.app.notifier.admin.dao.mapper;

import java.sql.ResultSet;
import java.sql.SQLException;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.notifier.notification.NotificationService;

/**
 * @author akirakozov
 */
public class NotificationServiceMarshaller implements RowMarshaller<NotificationService> {

    @Override
    public NotificationService mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new NotificationService(
                rs.getInt("id"),
                rs.getString("name"),
                rs.getString("tanker_keyset_id"),
                rs.getBoolean("is_yateam"));
    }

    public Tuple2List<String, Object> asColumnsValues(NotificationService service) {
        Tuple2List<String, Object> res = Tuple2List.arrayList();

        service.id.forEach(id -> res.add("id", id));
        res.add("name", service.name);
        res.add("tanker_keyset_id", service.tankerKeysetId);
        res.add("is_yateam", service.isYaTeam);

        return res;
    }
}
