package ru.yandex.chemodan.app.notifier.admin.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.admin.NotifierTypesRegistry;
import ru.yandex.chemodan.app.notifier.admin.NotifierTypesZkLastUpdateWatcher;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationGroupJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationRecordTypeJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotificationServiceJdbcDao;
import ru.yandex.chemodan.app.notifier.admin.dao.NotifierDataSourcePropertiesConfiguration;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.settings.NotifierWidgetSettingsManager;
import ru.yandex.chemodan.app.notifier.tanker.TankerRegistry;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author akirakozov
 */
@Configuration
@Import(NotifierDataSourcePropertiesConfiguration.class)
public class NotifierTypesAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Bean
    public NotifierTypesAdminPage notifierTypesAdminPage(
            NotifierTypesRegistry typesRegistry,
            TankerRegistry tankerRegistry,
            NotifierWidgetSettingsManager notifierWidgetSettingsManager)
    {
        NotifierTypesAdminPage page =
                new NotifierTypesAdminPage(typesRegistry, tankerRegistry, notifierWidgetSettingsManager);
        adminApp.registerAdminPage(Option.empty(), page);
        return page;
    }

    @Bean
    public NotifierTypesRegistry notifierTypesRegistry(
            NotificationRecordTypeJdbcDao typesDao, NotificationGroupJdbcDao groupDao,
            NotificationServiceJdbcDao serviceDao, NotifierTypesZkLastUpdateWatcher watcher)
    {
        return new NotifierTypesRegistry(typesDao, groupDao, serviceDao, watcher::onWrite);
    }


    @Bean
    public NotifierTypesZkLastUpdateWatcher notifierTypesZkLastUpdateWatcher(
            @Qualifier("zkRoot") ZkPath zkRoot,
            ZkManager zkManager,
            NotificationRecordTypeManager typeManager)
    {
        NotifierTypesZkLastUpdateWatcher watcher = new NotifierTypesZkLastUpdateWatcher(
                zkRoot.child("notifier_types"), typeManager);
        zkManager.addClient(watcher);
        return watcher;
    }
}
