<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="names" select="/page/content/names"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>
                <xsl:choose>
                    <xsl:when test="group/id">
                        Edit notification group <b style="color:blue"><xsl:value-of select="group/name"/></b>
                    </xsl:when>
                    <xsl:otherwise>
                        Add new notification group
                    </xsl:otherwise>
                </xsl:choose>
                 for service <b style="color:blue"><xsl:value-of select="service/name"/></b>
            </h2>

            <form class="form-horizontal" method="POST" action="add-group?serviceId={service/id}">
                <input type="hidden" name="groupId" value="{group/id}"/>
                <div class="control-group">
                    <label class="control-label">Group name</label>
                    <div class="controls">
                        <input type="text" name="name" value="{group/name}"/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="description">Description</label>
                    <div class="controls">
                        <textarea name="description" cols="50" rows="5">
                            <xsl:value-of select="group/description"/>
                        </textarea>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Custom settings group name</label>
                    <div class="controls">
                        <input type="text" name="settingsGroupName" value="{group/settings-group-name}"/>
                    </div>
                </div>
                <xsl:apply-templates select="names"/>
                <br/>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn">Save</button>
                    </div>
                </div>
            </form>
        </div>

    </xsl:template>

    <xsl:template match="names">
        <xsl:variable name="key" select="key"/>

        <div class="control-group">
            <label class="control-label">Group name for <b style="color:blue"><xsl:value-of select="key"/></b> language</label>
            <div class="controls">
                <input type="text" name="{key}Name" value="{$names[key=$key]/value}"/>
            </div>
        </div>
    </xsl:template>
</xsl:stylesheet>
