<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Notification services</h2>
            <ul>
                <xsl:apply-templates select="services/service"/>
            </ul>

            <h2>Add new service</h2>
            <form class="form-horizontal" method="GET" action="notifier-types/add-service">
                <div class="control-group">
                    <label class="control-label">Service name</label>
                    <div class="controls">
                        <input type="text" name="newServiceName"/>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn">Add</button>
                    </div>
                </div>
            </form>

            <h2>Update keys from tanker</h2>
            <form class="form-horizontal" method="POST" action="notifier-types/update-tanker-keys">
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn">Update cache</button>
                    </div>
                </div>
            </form>
        </div>

    </xsl:template>

    <xsl:template match="service">
        <li>
            <a href="/z/service-notifier-types?serviceId={id}"><xsl:value-of select="name"/></a>
        </li>
    </xsl:template>

</xsl:stylesheet>
