<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>Service <b style="color:blue"><xsl:value-of select="service/name"/></b></h2>

            <a href="notifier-types/add-service?serviceId={service/id}">Edit service settings</a>

            <h2>Notification groups</h2>
            <table class="fixed-table table table-striped table-condensed table-bordered">
                <tr>
                    <th width="20%">Name</th>
                    <th>Description</th>
                    <th>Custom settings group name</th>
                </tr>

                <xsl:apply-templates select="groups/group">
                    <xsl:with-param name="serviceId" select="service/id"/>
                </xsl:apply-templates>
            </table>

            <a href="notifier-types/add-group?serviceId={service/id}">Add new notification group</a>

            <h2>Notification types</h2>
            <table class="fixed-table table table-striped table-condensed table-bordered">
                <tr>
                    <th width="20%">Name</th>
                    <th>Description</th>
                    <th>Group</th>
                    <th>Icon</th>
                    <th>Message</th>
                    <th>Short message</th>
                    <th>Title message</th>
                    <th>Delay in ms</th>
                </tr>
                <xsl:apply-templates select="types/type">
                    <xsl:with-param name="serviceId" select="service/id"/>
                </xsl:apply-templates>
            </table>

            <a href="notifier-types/add-type?serviceId={service/id}">Add new notification type</a>
        </div>

    </xsl:template>

    <xsl:template match="group">
        <xsl:param name = "serviceId"/>
        <tr>
            <td><a href="notifier-types/add-group?serviceId={$serviceId}&amp;groupId={id}"><xsl:value-of select="name"/></a></td>
            <td><xsl:value-of select="description"/></td>
            <td><xsl:value-of select="settings-group-name"/></td>
        </tr>
    </xsl:template>

    <xsl:template match="type">
        <xsl:param name = "serviceId"/>
        <tr>
            <td><a href="notifier-types/add-type?serviceId={$serviceId}&amp;typeId={id}"><xsl:value-of select="name"/></a></td>
            <td><xsl:value-of select="description"/></td>
            <td><xsl:value-of select="group/name"/></td>
            <td><xsl:value-of select="icon/name"/></td>
            <td><xsl:value-of select="tanker-message-key"/></td>
            <td><xsl:value-of select="tanker-short-message-key"/></td>
            <td><xsl:value-of select="tanker-title-message-key"/></td>
            <td><xsl:value-of select="delay"/></td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
