<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:ya="urn:yandex-functions"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:variable name="names" select="/page/content/names"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript">
            $('.extra-widget-settings-link').click(function() {
                $(".extra-widget-settings-div").toggle();
            });
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>
                <xsl:choose>
                    <xsl:when test="service/id">
                        Edit service <b style="color:blue"><xsl:value-of select="service/name"/></b>
                    </xsl:when>
                    <xsl:otherwise>
                        Add new service
                    </xsl:otherwise>
                </xsl:choose>
            </h2>

            <form class="form-horizontal" method="POST" action="add-service">
                <input type="hidden" name="serviceId" value="{service/id}"/>
                <div class="control-group">
                    <label class="control-label">Service name</label>
                    <div class="controls">
                        <input type="text" name="name" value="{service/name}"/>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Tanker keyset id</label>
                    <div class="controls">
                        <input type="text" name="tankerKeysetId" value="{service/tanker-keyset-id}"/>
                    </div>
                </div>
                <div class="control-group">
                    <xsl:copy-of select="ya:checkbox('isYaTeam', 'This service is yandex-team', service/is-ya-team = 'true')"/>
                </div>
                <div class="control-group">
                    <label class="control-label">Icon src</label>
                    <div class="controls">
                        <input type="text" name="iconSrc" value="{widget-settings/icon-src}"/>
                    </div>
                </div>
                <xsl:apply-templates select="names"/>
                <br/>
                <a href="#" class="extra-widget-settings-link">Show/hide additional widget settings</a>
                <div class="extra-widget-settings-div" style="display: none">
                    <div class="control-group">
                        <label class="control-label">Block collection</label>
                        <div class="controls">
                            <input type="text" name="blockCollection" value="{widget-settings/block-collection}"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Icon type</label>
                        <div class="controls">
                            <input type="text" name="iconType" value="{widget-settings/icon-type}"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Message collection</label>
                        <div class="controls">
                            <input type="text" name="messageCollection" value="{widget-settings/message-collection}"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Settings collection</label>
                        <div class="controls">
                            <input type="text" name="settingsCollection" value="{widget-settings/settings-collection}"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Unviewed collection</label>
                        <div class="controls">
                            <input type="text" name="unviewedCollection" value="{widget-settings/unviewed-collection}"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label">Unviewed record</label>
                        <div class="controls">
                            <input type="text" name="unviewedRecord" value="{widget-settings/unviewed-record}"/>
                        </div>
                    </div>
                </div>
                <br/>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn">Save</button>
                    </div>
                </div>
            </form>
        </div>

    </xsl:template>

    <xsl:template match="names">
        <xsl:variable name="key" select="key"/>

        <div class="control-group">
            <label class="control-label">Service name for <b style="color:blue"><xsl:value-of select="key"/></b> language</label>
            <div class="controls">
                <input type="text" name="{key}Name" value="{$names[key=$key]/value}"/>
            </div>
        </div>
    </xsl:template>

    <xsl:function name="ya:checkbox">
        <xsl:param name="name"/>
        <xsl:param name="title"/>
        <xsl:param name="checked"/>

        <div class="checkbox">
            <label>
                <input type="checkbox" name="{$name}" value="true">
                    <xsl:if test="$checked">
                        <xsl:attribute name="checked"/>
                    </xsl:if>
                    <xsl:value-of select="$title"/>
                </input>
            </label>
        </div>
    </xsl:function>

</xsl:stylesheet>