<?xml version="1.0"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        exclude-result-prefixes="#all"
>

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript">
            $('.add-link').click(function() {
                $('#template-table')
                    .find('.view-edit-container').clone(true)
                    .data('creating', true)
                    .appendTo($('#variants-table').show())
                    .find('.edit-link').click();
                return false;
            });

            $('.edit-link').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.view').hide().end()
                    .find('.edit').show().end();
                return false;
            });

            $('.accept-link').click(function() {
                $(this).parents('.view-edit-container')
                    .data('creating', false)
                    .find('.view').show().end()
                    .find('.edit').hide().end()
                    .find(':input').each(function() {
                        $(this).parents('.view-edit-container')
                            .find('[data-name=\'' + $(this).attr('name') + '\']')
                            .text($(this).val());
                    })
                return false;
            });

            $('.cancel-link').click(function() {
                var $row = $(this).parents('.view-edit-container');

                if ($row.data('creating')) {
                    return $row.find('.remove-link').click();
                }

                $row.find('.view').show().end()
                    .find('.edit').hide().end()
                    .find('[data-name]').each(function() {
                        $(this).parents('.view-edit-container')
                            .find(':input[name=\'' + $(this).data('name') + '\']')
                            .val($(this).text());
                    })
                return false;
            });

            $('.remove-link').click(function() {
                $(this).parents('.view-edit-container').remove();

                $('#variants-table').toggle($('#variants-table .view-edit-container').length > 0);

                return false;
            });
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="content" class="container">
            <h2>
                <xsl:choose>
                  <xsl:when test="type/id">
                      Edit notification type <b style="color:blue"><xsl:value-of select="type/name"/></b>
                  </xsl:when>
                  <xsl:otherwise>
                      Add new notification type
                  </xsl:otherwise>
                </xsl:choose>
                  for service <b style="color:blue"><xsl:value-of select="service/name"/></b>
            </h2>

            <form class="form-horizontal" method="POST" action="add-type?serviceId={service/id}">
                <input type="hidden" name="typeId" value="{type/id}"/>
                <table width="100%">
                    <tr>
                        <td><label class="control-label">Type name: </label></td>
                        <td><input type="text" name="name" value="{type/name}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Icon id: </label></td>
                        <td><input type="text" name="icon" value="{type/icon/name}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Group: </label></td>
                        <td><select name="groupId">
                            <xsl:apply-templates select="groups/group">
                                <xsl:with-param name="currentGroupId" select="type/group-id"/>
                            </xsl:apply-templates>
                        </select></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Tanker message key: </label></td>
                        <td><input type="text" name="tankerMessageKey" value="{type/tanker-message-key}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Tanker short message key: </label></td>
                        <td><input type="text" name="tankerShortMessageKey" value="{type/tanker-short-message-key}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Tanker title message key: </label></td>
                        <td><input type="text" name="tankerTitleMessageKey" value="{type/tanker-title-message-key}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Delay in ms: </label></td>
                        <td><input type="text" name="delay" value="{delay}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Aggregate function type: </label></td>
                        <td><select name="aggregatorType">
                            <xsl:apply-templates select="aggregator-types/type">
                                <xsl:with-param name="currentAggregatorType" select="type/counter-configuration/type"/>
                            </xsl:apply-templates>
                        </select></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Aggregate function parameter: </label></td>
                        <td><input type="text" name="aggregatorParams" value="{type/counter-configuration/params}" style="width:100%"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label" for="description">Description</label></td>
                        <td>
                            <textarea name="description" cols="50" rows="5">
                                <xsl:value-of select="type/description"/>
                            </textarea>
                        </td>
                    </tr>
                    <tr>
                        <td><label class="control-label" for="defaultMetadata">Default metadata</label></td>
                        <td>
                            <textarea name="defaultMetadata" cols="50" rows="5">
                                <xsl:value-of select="default-metadata"/>
                            </textarea>
                        </td>
                    </tr>
                </table>
                <label class="control-label">Alternative variants</label>
                <br/>

                <table id="variants-table" class="table table-striped table-condensed table-bordered">
                    <xsl:if test="count(type/alternative-variants) = 0">
                        <xsl:attribute name="style">display: none</xsl:attribute>
                    </xsl:if>
                    <tr>
                        <th width="20%">Name</th>

                        <th>Users %</th>
                        <th>Offset %</th>

                        <th>Icon</th>
                        <th>Message key</th>
                        <th>Title message key</th>
                        <th>Short message key</th>
                        <th>Delay in ms</th>
                        <th>Default metadata</th>
                        <th>Actions</th>
                    </tr>
                    <xsl:for-each select="type/alternative-variants">
                        <xsl:variable name="pos" select="position()"/>

                        <xsl:apply-templates select="." mode="variant-row">
                            <xsl:with-param name="meta" select="../../alternative-metadata/variant[position()=$pos]"/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </table>
                <a href="#" class="add-link">Add new one</a>

                <br/><br/>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" class="btn btn-default">Save</button>
                    </div>
                </div>
            </form>
        </div>
        <table id="template-table" style="display: none">
            <xsl:apply-templates select="." mode="variant-row"/>
        </table>

    </xsl:template>

    <xsl:template match="group">
        <xsl:param name = "currentGroupId"/>
        <option value="{id}">
            <xsl:if test="$currentGroupId=id">
                <xsl:attribute name="selected">selected</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="name"/>
        </option>
    </xsl:template>

    <xsl:template match="type">
        <xsl:param name = "currentAggregatorType"/>
        <option value="{text()}">
            <xsl:if test="$currentAggregatorType=text()">
                <xsl:attribute name="selected">selected</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="text()"/>
        </option>
    </xsl:template>

    <xsl:template match="*" mode="variant-row">
        <xsl:param name="meta"/>

        <tr class="view-edit-container">
            <td class="view" data-name="variants.name">
                <xsl:value-of select="name"/>
            </td>
            <td class="view" data-name="variants.users">
                <xsl:value-of select="users-percent"/>
            </td>
            <td class="view" data-name="variants.offset">
                <xsl:value-of select="offset-percent"/>
            </td>
            <td class="view" data-name="variants.icon">
                <xsl:value-of select="icon"/>
            </td>
            <td class="view" data-name="variants.message">
                <xsl:value-of select="message-key"/>
            </td>
            <td class="view" data-name="variants.title">
                <xsl:value-of select="title-message-key"/>
            </td>
            <td class="view" data-name="variants.short">
                <xsl:value-of select="short-message-key"/>
            </td>
            <td class="view" data-name="variants.delay">
                <xsl:value-of select="delay"/>
            </td>
            <td class="view" data-name="variants.meta">
                <xsl:value-of select="$meta"/>
            </td>

            <td class="view">
                <a href="#" class="edit-link">Edit</a>
                <xsl:text>&#160;&#160;</xsl:text>
                <a href="#" class="remove-link">Remove</a>
            </td>

            <td class="edit" colspan="9" style="display: none; padding: 20px">
                <table style="width: 100%">
                    <tr>
                        <td width="20%"/><td/>
                    </tr>
                    <tr>
                        <td><label class="control-label">Name *</label></td>
                        <td><input type="text" name="variants.name" value="{name}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Users % *</label></td>
                        <td><input type="text" name="variants.users" value="{users-percent}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Offset % *</label></td>
                        <td><input type="text" name="variants.offset" value="{offset-percent}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Icon: </label></td>
                        <td><input type="text" name="variants.icon" value="{icon}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Message key: </label></td>
                        <td><input type="text" name="variants.message" value="{message-key}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Title message key: </label></td>
                        <td><input type="text" name="variants.title" value="{title-message-key}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Short message key: </label></td>
                        <td><input type="text" name="variants.short" value="{short-message-key}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Delay in ms: </label></td>
                        <td><input type="text" name="variants.delay" value="{delay}"/></td>
                    </tr>
                    <tr>
                        <td><label class="control-label">Default metadata: </label></td>
                        <td>
                            <textarea name="variants.meta" cols="50" rows="5">
                                <xsl:value-of select="$meta"/>
                            </textarea>
                        </td>
                    </tr>
                    <tr>
                        <td/>
                        <td>
                            <button type="button" class="btn btn-primary submit accept-link" value="">Ok</button>
                            <xsl:text>&#160;&#160;</xsl:text>
                            <button type="button" class="btn btn-default cancel-link" value="">Cancel</button>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>
