package ru.yandex.chemodan.app.notifier.client;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.notifier.NotifierApp;
import ru.yandex.chemodan.app.notifier.actions.NotificationActionsContextConfiguration;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;

/**
 * @author buberman
 */
@Configuration
@Import({
        NotificationActionsContextConfiguration.class,
        A3JettyContextConfiguration.class
})
public class NotifierDaemonContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/notifier/*", NotifierApp.APP_NAME
        ));
    }
}
