package ru.yandex.chemodan.app.notifier.client;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.NotifierContextConfiguration;
import ru.yandex.chemodan.app.notifier.log.NotifierLogger;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author buberman
 */
public class NotifierMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        new NotifierMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("disk", "notifier");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(NotifierContextConfiguration.class);
    }

    @Override
    protected void configureLogger() {

        super.configureLogger();

        NotifierLogHelper.configureLogbrokerExLogging();

        NotifierLogHelper.appenderBuilder()
                .appName(applicationName())
                .name(NotifierLogger.logger.logger.name)
                .postfix("-events")
                .layout(NotifierLogger.logger.pattern)
                .async(false)
                .build();
    }
}
