package ru.yandex.chemodan.app.notifier.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.chemodan.app.notifier.notification.LocalizedMessage;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndType;

/**
 * @author buberman
 */
public interface NotificationBlockDao {
    Option<NotificationBlockRecord> findNotificationBlock(
            DataApiUserId userId, ServiceAndType type, String group);

    ListF<NotificationBlockRecord> findNotificationBlocks(
            DataApiUserId userId, ListF<ServiceAndType> types, String group);

    void updateNotificationBlock(
            DataApiUserId userId, String service, String recordId,
            NotificationBlockUpdate update,
            MapF<NotifierLanguage, LocalizedMessage> messages);

    void createNewNotificationBlockAndSiftOldest(
            DataApiUserId userId,
            NotificationBlockRecord record,
            MapF<NotifierLanguage, LocalizedMessage> messages);

    void markNotificationBlockAsRead
            (DataApiUserId userId, String groupKey, NotificationType recordType);

    int getUnviewedBlocksCountForService(DataApiUserId userId, String service);

    int getTotalUnviewedBlocksCountForEnabledServices(DataApiUserId userId);

    void deleteBlock(DataApiUserId userId, NotificationBlockRecord block);
}
