package ru.yandex.chemodan.app.notifier.dao;

import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.chemodan.app.notifier.NotificationTestUtils;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
@ActivateDataApiEmbeddedPg
public class NotificationCacheDaoTest extends DataApiTestSupport {

    @Autowired
    private DataApiManager dataApiManager;

    private DataApiUserId uid;
    private NotificationCacheDao notificationCacheDao;

    @Before
    public void setup() {
        uid = createRandomCleanUserInDefaultShard();

        notificationCacheDao = new NotificationCacheDaoImpl(dataApiManager);
    }

    @Test
    public void createFindDeleteNewNotification() {
        NotificationRecord record = NotificationTestUtils.createTestNewNotificationRecord("group_key1");
        notificationCacheDao.createNewNotification(uid, record);
        ListF<NotificationRecord> records = notificationCacheDao.findNewNotifications(
                uid, record.type, record.groupKey);

        Assert.hasSize(1, records);
        Assert.equals(record, records.get(0), "Notification record was stored or loaded incorrectly");

        notificationCacheDao.removeNewNotifications(
                uid, record.type, record.groupKey, Cf.list(record.id));

        ListF<NotificationRecord> recordsAfterRemove = notificationCacheDao.findNewNotifications(
                uid, record.type, record.groupKey);
        Assert.isEmpty(recordsAfterRemove);
    }

    @Test
    public void deleteFewNewNotifications() {
        int count = 3;
        String groupKey = "group_key2";
        NotificationType type = NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS;
        ListF<String> ids = Cf.arrayList();
        Cf.range(0, count).forEach(c -> {
                NotificationRecord r = NotificationTestUtils.createTestNewNotificationRecord(groupKey);
                notificationCacheDao.createNewNotification(uid, r);
                ids.add(r.id);
            });

        notificationCacheDao.removeNewNotifications(uid, type, groupKey, ids);
        ListF<NotificationRecord> recordsAfterRemove = notificationCacheDao.findNewNotifications(
                uid, type, groupKey);
        Assert.isEmpty(recordsAfterRemove);
    }

}
