package ru.yandex.chemodan.app.notifier.dao;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.notification.ServiceAndGroup;
import ru.yandex.chemodan.app.notifier.settings.SettingsRecord;

/**
 * @author buberman
 */
public interface NotificationSettingsDao {
    void disableResourceNotifications(DataApiUserId dataApiUserId, String resourceId,
            SetF<ServiceAndGroup> groups);

    void enableResourceNotifications(DataApiUserId dataApiUserId, String resourceId,
            SetF<ServiceAndGroup> groups);

    boolean isSubscribed(DataApiUserId dataApiUserId, String resourceId,
            ServiceAndGroup group);

    CollectionF<SettingsRecord> getSubscribedResources(
            DataApiUserId dataApiUserId, String service, Option<String> resource);
}
