package ru.yandex.chemodan.app.notifier.grants;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.notification.disk.DiskServices;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author akirakozov
 */
public class ServiceGrantsChecker {
    private static final Logger logger = LoggerFactory.getLogger(ServiceGrantsChecker.class);

    private final boolean enabled;

    public ServiceGrantsChecker(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean checkGrants(String serviceName, Option<String> sourceAppName) {
        if (!enabled) {
            logger.debug("Grants checker disabled");
            return true;
        }

        logger.debug("Check grants for application {} and notification service {} ", sourceAppName, serviceName);

        // Temporary allow for all add notifications to disk
        return serviceName.equals(DiskServices.DISK) || sourceAppName.isSome(serviceName);

    }
}
