package ru.yandex.chemodan.app.notifier.grants;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
public class ServiceGrantsCheckerTest {

    @Test
    public void checkGrants() {
        ServiceGrantsChecker checker = new ServiceGrantsChecker(true);

        Assert.isTrue(checker.checkGrants("disk", Option.empty()));
        Assert.isTrue(checker.checkGrants("disk", Option.of("mail")));
        Assert.isTrue(checker.checkGrants("disk", Option.of("disk")));

        Assert.isTrue(checker.checkGrants("mail", Option.of("mail")));
        Assert.isFalse(checker.checkGrants("mail", Option.of("music")));
        Assert.isFalse(checker.checkGrants("mail", Option.empty()));
    }
}
