package ru.yandex.chemodan.app.notifier.inflector;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;

/**
 * @author buberman
 */
public class InflectorClientImpl implements InflectorClient {
    protected static final BenderMapper inflectorResponseParserMapper = new BenderMapper(new BenderConfiguration(
            new BenderSettings(MembersToBind.ALL_FIELDS),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(InflectorResponse.class,
                            new InflectorResponseUnmarshaller())
                    .build()
    ));

    protected DynamicProperty<ListF<String>> sendHintsForLanguages =
                DynamicProperty.cons("inflector-send-hints-for-languages",
                        Cf.list("ru","uk"));

    private final String inflectorUrl;
    private final HttpClient httpClient;

    public InflectorClientImpl(String inflectorUrl, HttpClient httpClient) {
        this.inflectorUrl = inflectorUrl;
        this.httpClient = httpClient;
    }

    @Override
    public InflectorResponse inflectFio(String text, NotifierLanguage lang, Option<Gender> gender) {
        String response = ApacheHttpClientUtils.execute(new HttpGet(makeFioUrl(text, lang, gender)), httpClient, new ReadStringResponseHandler());

        return inflectorResponseParserMapper.parseJson(InflectorResponse.class, response);
    }

    @Override
    public InflectorResponse inflectGeo(String text, NotifierLanguage lang) {
        String response = ApacheHttpClientUtils.execute(new HttpGet(makeGeoUrl(text, lang)), httpClient, new ReadStringResponseHandler());

        return inflectorResponseParserMapper.parseJson(InflectorResponse.class, response);
    }

    String makeGeoUrl(String text, NotifierLanguage lang) {
        String query = text;

        query += ";gram=geo";
        query = appendLanguageCode(query, lang);

        return UrlUtils.addParameter(inflectorUrl, "text", query);
    }

    String makeFioUrl(String text, NotifierLanguage lang, Option<Gender> gender) {
        String query = text;

        if (sendHintsForLanguages.get().containsTs(lang.value()) && gender.isPresent()) {
            query += ":"+gender.get().value();
        }

        query += ";fio=1";
        query = appendLanguageCode(query, lang);

        return UrlUtils.addParameter(inflectorUrl, "text", query);
    }

    private String appendLanguageCode(String query, NotifierLanguage lang) {
        switch (lang) {
            case UKRAINIAN:
                return query + ";lang=ukr";
            default:
                return query;
        }
    }
}
