package ru.yandex.chemodan.app.notifier.inflector;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

/**
 * @author buberman
 */
@Configuration
public class InflectorConfiguration {

    @Bean
    public InflectorClient unwrappedInflectorClient(@Value("${inflector.url}") String inflectorUrl) {
        return new InflectorClientImpl(inflectorUrl, inflectorHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("inflector")
    public HttpClientConfigurator inflectorHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
