package ru.yandex.chemodan.app.notifier.inflector;

import java.util.LinkedHashMap;

import org.w3c.dom.Node;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.misc.bender.PartPosition;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.RootLevelUnmarshaller;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class InflectorResponseUnmarshaller implements FieldLevelUnmarshaller, RootLevelUnmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(InflectorResponseUnmarshaller.class);

    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext context) {
        throw new NotImplementedException("XML marshalling / unmarshalling not supported");
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        Option<BenderJsonNode> formsO = node.getField("Form");
        InflectorResponse result = new InflectorResponse();
        if (formsO.isPresent() && formsO.get().isArray()) {
            ListF<BenderJsonNode> forms = formsO.get().getArrayElements();

            result.forms = Cf.x(new LinkedHashMap<String, String>());

            for (BenderJsonNode form : forms) {
                Option<BenderJsonNode> grammar = form.getField("Grammar");
                Option<BenderJsonNode> text = form.getField("Text");
                if (grammar.isPresent() && text.isPresent()) {
                    result.forms.put(grammar.get().getValueAsString(), text.get().getValueAsString());
                } else {
                    logger.warn("Unable to parse Inflector response part: " + form.toString());
                }
            }

        } else {
            logger.warn("Empty Inflector response.");
            result.forms = Cf.map();
        }
        return ParseResult.result(result);
    }

    @Override
    public ParseResult<Object> parseO(XmlOrJsonNode node, PartPosition pp, UnmarshallerContext context) {
        if (node.isXml()) {
            return parseXmlNode(node.getXml(), context);
        } else {
            return parseJsonNode(node.getJson(), context);
        }
    }
}
