package ru.yandex.chemodan.app.notifier.inflector;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.NotifierLanguage;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author buberman
 */
@YaExternal
public class InflectorTest {
    public static final String INFLECTOR_URL = "http://hamzard.yandex.net:8891/wizard?format=json&action=inflector";

    protected InflectorClientImpl inflectorClient =
            new InflectorClientImpl(INFLECTOR_URL, ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(1)));

    @Test
    public void inflectSimpleName() {
        InflectorResponse inflectorResponse =
                inflectorClient.inflectFio("Вася Пупкин", NotifierLanguage.RUSSIAN, Option.of(Gender.M));

        Assert.equals(6, inflectorResponse.forms.size());
        Assert.equals("Вася Пупкин", inflectorResponse.forms.getTs("им"));
        Assert.equals("Васи Пупкина", inflectorResponse.forms.getTs("род"));
        Assert.equals("Васе Пупкину", inflectorResponse.forms.getTs("дат"));
        Assert.equals("Васю Пупкина", inflectorResponse.forms.getTs("вин"));
        Assert.equals("Васей Пупкиным", inflectorResponse.forms.getTs("твор"));
        Assert.equals("Васе Пупкине", inflectorResponse.forms.getTs("пр"));
    }

    @Test
    public void inflectGeo() {
        InflectorResponse inflectorResponse =
                inflectorClient.inflectGeo("Россия", NotifierLanguage.RUSSIAN);

        Assert.equals("Россия", inflectorResponse.forms.getTs("им"));
        Assert.equals("России", inflectorResponse.forms.getTs("род"));
        Assert.equals("России", inflectorResponse.forms.getTs("дат"));
        Assert.equals("Россию", inflectorResponse.forms.getTs("вин"));
        Assert.equals("Россией", inflectorResponse.forms.getTs("твор"));
        Assert.equals("России", inflectorResponse.forms.getTs("пр"));
        Assert.equals("России", inflectorResponse.forms.getTs("местн"));
    }

    @Test
    public void makeUrl() {
        inflectorClient.sendHintsForLanguages = DynamicProperty.cons("inflector-send-hints-for-languages-test", Cf.list("ru"));

        String urlNoLangWithHints = inflectorClient.makeFioUrl("Вася Пупкин", NotifierLanguage.RUSSIAN, Option.of(Gender.M));
        String expectedUrlParams = UrlUtils.urlEncode("Вася Пупкин:m;fio=1");
        Assert.equals(INFLECTOR_URL + "&text=" + expectedUrlParams, urlNoLangWithHints);

        String urlWithLangNoHints = inflectorClient.makeFioUrl("Вася Пупкин", NotifierLanguage.UKRAINIAN, Option.of(Gender.M));
        expectedUrlParams = UrlUtils.urlEncode("Вася Пупкин;fio=1;lang=ukr");
        Assert.equals(INFLECTOR_URL + "&text=" + expectedUrlParams, urlWithLangNoHints);
    }
}
