package ru.yandex.chemodan.app.notifier.locale;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.notifier.inflector.InflectorClient;
import ru.yandex.chemodan.app.notifier.inflector.InflectorConfiguration;
import ru.yandex.chemodan.app.notifier.tanker.TankerManager;
import ru.yandex.chemodan.app.notifier.tanker.TankerManagerConfiguration;

/**
 * @author akirakozov
 */
@Configuration
@Import({TankerManagerConfiguration.class,
        InflectorConfiguration.class})
public class LocaleContextConfiguration {
    @Bean
    public LocaleManager localeManager(TankerManager tankerManager, InflectorClient inflectorClient) {
        return new LocaleManager(tankerManager, inflectorClient);
    }

}
