package ru.yandex.chemodan.app.notifier.log.listener;

import lombok.AllArgsConstructor;

import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author bursy
 */
@AllArgsConstructor
public class NotifierLogListener implements LogListener {
    private static final Logger logger = LoggerFactory.getLogger(NotifierLogListener.class);

    private LogListener notifierEventsLogListener;
    private LogListener notifierBassLogListener;

    @Override
    public void processLogLine(String line) {
        LogListener logListener;

        try {
            logListener = determineLogListener(line);
        } catch (Exception e) {
            logger.error("Unable to determine log listener for line {}", line, e);
            return;
        }

        logListener.processLogLine(line);
    }

    private LogListener determineLogListener(String line) {
        return isJsonLine(line) ? notifierBassLogListener : notifierEventsLogListener;
    }

    private boolean isJsonLine(String line) {
        // very naive way, but it's fastest - there's no need for strict correctness, basic distinction is good enough
        return line.charAt(0) == '{';
    }
}
