package ru.yandex.chemodan.app.notifier.log.listener.bass;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author bursy
 */
@AllArgsConstructor
@BenderBindAllFields
public class BassLogEntry {
    public final String uid;
    public final String actor;
    public final String type;
    public final String service;

    public final long unixtime;

    @BenderPart(name = "group_key", strictName = true)
    public final Option<String> groupKey;
    @BenderPart(name = "subscription_key", strictName = true)
    public final Option<String> subscriptionKey;
    public final Option<MetadataWrapper> meta;
}
