package ru.yandex.chemodan.app.notifier.log.listener.bass;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.chemodan.app.notifier.notification.NewNotificationData;
import ru.yandex.chemodan.app.notifier.notification.NotificationActor;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.chemodan.app.notifier.notification.NotificationType;
import ru.yandex.chemodan.app.notifier.utils.NotifierUtils;
import ru.yandex.commune.salr.logreader.LogListener;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author bursy
 */
@AllArgsConstructor
public class NotifierBassLogListener implements LogListener {
    private static final Logger logger = LoggerFactory.getLogger(NotifierBassLogListener.class);

    private static final BenderParserSerializer<BassLogEntry> parserSerializer =
            MetadataWrapper.mapper.createParserSerializer(BassLogEntry.class);

    private NotificationManager notificationManager;
    private NotificationRecordTypeManager notificationRecordTypeManager;

    @Override
    public void processLogLine(String line) {
        try {
            BassLogEntry logEntry = parserSerializer.getParser().parseJson(line);

            DataApiUserId userId = DataApiUserId.parse(logEntry.uid);
            NotificationActor actor = NotificationActor.consFromSerialized(logEntry.actor);
            NotificationType recordType =
                    notificationRecordTypeManager.resolveRecordType(logEntry.type, logEntry.service);
            MetadataWrapper meta =
                    logEntry.meta.getOrElse(MetadataWrapper.createEmpty()).mergeWith(recordType.defaultMetadata);

            notificationManager.createNewNotification(new NewNotificationData(userId, actor, logEntry.subscriptionKey,
                    logEntry.groupKey.getOrElse(NotifierUtils.generateRandomGroupKey()), recordType, meta));
        } catch (Exception e) {
            logger.error("Notification data parsing failed for line {}", line, e);
        }
    }
}
