package ru.yandex.chemodan.app.notifier.log.listener.bass;

import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.notifier.NotificationManager;
import ru.yandex.chemodan.app.notifier.NotificationTestUtils;
import ru.yandex.chemodan.app.notifier.notification.NewNotificationData;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecordTypeManager;
import ru.yandex.misc.test.Assert;

/**
 * @author bursy
 */
public class NotifierBassLogListenerTest {
    private NotifierBassLogListener notifierBassLogListener;

    @Mock
    private NotificationManager notificationManager;
    @Mock
    private NotificationRecordTypeManager notificationRecordTypeManager;

    private static String SERVICE = "dummy_service";
    private static String TYPE = "dummy_type";

    @Before
    public void setup() {
        MockitoAnnotations.initMocks(this);

        notifierBassLogListener = new NotifierBassLogListener(notificationManager, notificationRecordTypeManager);
        Mockito.when(notificationRecordTypeManager.resolveRecordType(TYPE, SERVICE)).thenReturn(
                NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS);
    }

    @Test
    public void processLogLine() {
        String uid = "123";
        String actor = "234";
        String groupKey = "groupKey345";
        String subscriptionKey = "subscriptionKey456";
        String metaFieldText = "some_text";

        String line = "{\"uid\": \"" + uid + "\", "
                + "\"actor\": \"" + actor + "\", "
                + "\"type\": \"" + TYPE + "\", "
                + "\"service\":\"" + SERVICE + "\", "
                + "\"unixtime\": 123, "
                + "\"group_key\": \"" + groupKey + "\", "
                + "\"subscription_key\": \"" + subscriptionKey + "\", "
                + "\"meta\": {\"field\": {\"type\": \"text\", \"text\": \"" + metaFieldText + "\"}}}";

        notifierBassLogListener.processLogLine(line);

        ArgumentCaptor<NewNotificationData> args = ArgumentCaptor.forClass(NewNotificationData.class);
        Mockito.verify(notificationManager, Mockito.atLeastOnce()).createNewNotification(args.capture());

        NewNotificationData data = Cf.toList(args.getAllValues()).first();

        Assert.equals(uid, data.owner.toString());
        Assert.equals(actor, data.actor.toString());
        Assert.equals(NotificationTestUtils.NOTIFICATION_TYPE_FOR_TESTS, data.type);
        Assert.equals(groupKey, data.groupKey);
        Assert.equals(subscriptionKey, data.subscriptionKey.get());
        Assert.equals(metaFieldText, data.metadata.getEntityField("field", "text").get());
    }
}
