package ru.yandex.chemodan.app.notifier.log.listener.bass;

import ru.yandex.chemodan.eventlog.celery.CeleryLogLineUtils;
import ru.yandex.chemodan.eventlog.celery.ProcessLogLineCeleryTask;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.impl.TaskId;

/**
 * @author bursy
 */
public class ProcessNotifierBassLogLineCeleryTask extends ProcessLogLineCeleryTask<NotifierBassLogListener> {
    public ProcessNotifierBassLogLineCeleryTask(NotifierBassLogListener listener) {
        super(listener);
    }

    public ProcessNotifierBassLogLineCeleryTask(String logLine) {
        super(CeleryLogLineUtils.toCeleryOneTimeTaskParameters(logLine));
    }

    @Override
    protected TaskId celeryTaskId() {
        return new TaskId("notifier.process_bass_log_line");
    }

    @Override
    protected String toLogLine(CeleryOnetimeTaskParameters celeryOnetimeTaskParameters) {
        return CeleryLogLineUtils.toLogLine(celeryOnetimeTaskParameters);
    }
}
