package ru.yandex.chemodan.app.notifier.log.listener.events;

import ru.yandex.chemodan.eventlog.celery.CeleryLogLineUtils;
import ru.yandex.chemodan.eventlog.celery.ProcessLogLineCeleryTask;
import ru.yandex.chemodan.eventlog.log.TskvLogLine;
import ru.yandex.chemodan.queller.worker.CeleryOnetimeTaskParameters;
import ru.yandex.commune.bazinga.impl.TaskId;

/**
 * @author bursy
 */
public class ProcessNotifierEventsLogLineCeleryTask extends ProcessLogLineCeleryTask<NotifierEventsLogListener> {
    public ProcessNotifierEventsLogLineCeleryTask(NotifierEventsLogListener listener) {
        super(listener);
    }

    public ProcessNotifierEventsLogLineCeleryTask(String logLine) {
        super(CeleryLogLineUtils.toCeleryOneTimeTaskParameters(TskvLogLine.parse(logLine)));
    }

    @Override
    protected TaskId celeryTaskId() {
        return new TaskId("notifier.process_events_log_line");
    }

    @Override
    protected String toLogLine(CeleryOnetimeTaskParameters celeryOnetimeTaskParameters) {
        return CeleryLogLineUtils.toTskvLogLine(celeryOnetimeTaskParameters);
    }
}
