package ru.yandex.chemodan.app.notifier.masters;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.masters.counter.CountMaster;
import ru.yandex.chemodan.app.notifier.masters.counter.CountMasterManager;
import ru.yandex.chemodan.app.notifier.masters.counter.IncrementCountMaster;
import ru.yandex.chemodan.app.notifier.masters.counter.PlusCountMaster;
import ru.yandex.chemodan.app.notifier.masters.counter.UniqueButOneCountMaster;
import ru.yandex.chemodan.app.notifier.masters.counter.UniqueCountMaster;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author buberman
 */
@Configuration
public class MastersConfiguration {
    @Bean
    public IncrementCountMaster incrementCountMaster() {
        return new IncrementCountMaster();
    }

    @Bean
    public UniqueCountMaster uniqueCountMaster() {
        return new UniqueCountMaster();
    }

    @Bean
    public UniqueButOneCountMaster uniqueButOneCountMaster() {
        return new UniqueButOneCountMaster();
    }

    @Bean
    public PlusCountMaster plusCountMaster() {
        return new PlusCountMaster();
    }

    @Bean
    public CountMasterManager countMasterManager(ApplicationContext context) {
        ListF<CountMaster> countMasters = ApplicationContextUtils.beansOfType(context, CountMaster.class);
        return new CountMasterManager(countMasters);
    }

    @Bean
    public MasterManager masterManager(CountMasterManager countMasterManager) {
        return new MasterManager(countMasterManager);
    }
}
