package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public interface CountMaster {
    CounterType getCounterType();

    NotificationBlockUpdate initialCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications
    );

    default NotificationBlockUpdate updateCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            NotificationBlockRecord block,
            ListF<NotificationRecord> newNotifications)
    {
        Long initialCount = initialCount(config, update, newNotifications).count.getOrElse(0L);
        return update.withCount(block.count.getOrElse(0L) + initialCount);
    }
}
