package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public class CountMasterManager {
    private MapF<CounterType, CountMaster> countMasters = Cf.hashMap();

    private static final CountMaster DEFAULT_MASTER = new DefaultCountMaster();

    public CountMasterManager(ListF<CountMaster> countMasters) {
        for (CountMaster master : countMasters) {
            this.countMasters.put(master.getCounterType(), master);
        }
    }

    public NotificationBlockUpdate adjustCount(
            NotificationBlockUpdate update,
            NotificationBlockRecord block,
            ListF<NotificationRecord> newNotifications)
    {
        return countMasters
                .getOrElse(block.type.counterConfiguration.counterType, DEFAULT_MASTER)
                .updateCount(block.type.counterConfiguration, update, block, newNotifications);
    }

    public NotificationBlockUpdate startCount(
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications)
    {
        return countMasters
                .getOrElse(newNotifications.first().type.counterConfiguration.counterType, DEFAULT_MASTER)
                .initialCount(newNotifications.first().type.counterConfiguration, update, newNotifications);
    }

    private static class DefaultCountMaster implements CountMaster {
        @Override
        public CounterType getCounterType() {
            return CounterType.NONE;
        }

        @Override
        public NotificationBlockUpdate initialCount(
                CounterConfiguration config,
                NotificationBlockUpdate update,
                ListF<NotificationRecord> newNotifications)
        {
            return update;
        }
    }
}
