package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public class IncrementCountMaster implements CountMaster {
    @Override
    public CounterType getCounterType() {
        return CounterType.INCREMENT;
    }

    @Override
    public NotificationBlockUpdate initialCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications)
    {
        return update.withCount(newNotifications.size());
    }
}
