package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public abstract class MetadataFieldCountMaster<T> implements CountMaster {
    private static final Logger logger = LoggerFactory.getLogger(MetadataFieldCountMaster.class);

    protected MetadataReference parseReference(String param) {
        String[] entityAndField = param.split("\\.");
        if (entityAndField.length != 2) {
            return new MetadataReference(false, "", "");
        }
        return new MetadataReference(true, entityAndField[0], entityAndField[1]);
    }


    T getMetadataField(
            NotificationRecord notification,
            MetadataReference ref,
            Function<String, T> convert,
            T defaultValue)
    {
        Option<String> value = notification.metadata.getEntityField(ref.entity, ref.field);
        if (!value.isPresent()) {
            logger.error("Invalid meta or configuration for record with type {}, id {}, count update may be wrong",
                    notification.type.value(), notification.id);
            return defaultValue;
        }

        return convert.apply(value.get());
    }

    protected static class MetadataReference {
        final boolean valid;
        final String entity;
        final String field;

        public MetadataReference(boolean valid, String entity, String field) {
            this.valid = valid;
            this.entity = entity;
            this.field = field;
        }
    }
}
