package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class PlusCountMaster extends MetadataFieldCountMaster<Long> {
    private static final Logger logger = LoggerFactory.getLogger(PlusCountMaster.class);

    @Override
    public CounterType getCounterType() {
        return CounterType.PLUS;
    }

    @Override
    public NotificationBlockUpdate initialCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications)
    {
        MetadataReference ref = parseReference(config.params.first());
        if (!ref.valid) {
            logger.error("Invalid config for type {}, count not updated", newNotifications.first().type.value());
            return update;
        }

        long newCount = newNotifications
                .map(n -> getMetadataField(n, ref, Long::parseLong, 0L))
                .reduceLeft((i1, i2) -> i1+i2);

        return update.withCount(newCount);
    }
}
