package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;

/**
 * @author buberman
 */
public class UniqueButOneCountMaster extends UniqueCountMaster {

    @Override
    public CounterType getCounterType() {
        return CounterType.UNIQUE_BUT_ONE;
    }

    @Override
    public NotificationBlockUpdate initialCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications)
    {
        NotificationBlockUpdate result = super.initialCount(config, update, newNotifications);
        return result.withCount(result.count.getOrElse(1L)-1);
    }

    @Override
    public NotificationBlockUpdate updateCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            NotificationBlockRecord block,
            ListF<NotificationRecord> newNotifications)
    {
        NotificationBlockUpdate result = super.updateCount(config, update, block, newNotifications);
        return result.withCount(result.count.getOrElse(1L) - 1);
    }
}
