package ru.yandex.chemodan.app.notifier.masters.counter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.notifier.config.CounterConfiguration;
import ru.yandex.chemodan.app.notifier.config.CounterType;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockRecord;
import ru.yandex.chemodan.app.notifier.notification.NotificationBlockUpdate;
import ru.yandex.chemodan.app.notifier.notification.NotificationRecord;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author buberman
 */
public class UniqueCountMaster extends MetadataFieldCountMaster<String> {
    private static final Logger logger = LoggerFactory.getLogger(UniqueCountMaster.class);

    @Override
    public CounterType getCounterType() {
        return CounterType.UNIQUE;
    }

    @Override
    public NotificationBlockUpdate initialCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            ListF<NotificationRecord> newNotifications)
    {
        MetadataReference ref = parseReference(config.params.first());
        if (!ref.valid) {
            logger.error("Invalid config for type {}, count not updated", newNotifications.first().type.value());
            return update;
        }

        ListF<String> newUniques = newNotifications
                .map(n -> getMetadataField(n, ref, s -> s, ""))
                .stableUnique();
        return update
                .withCount(newUniques.size())
                .withCounterUniques(newUniques);
    }

    @Override
    public NotificationBlockUpdate updateCount(
            CounterConfiguration config,
            NotificationBlockUpdate update,
            NotificationBlockRecord block,
            ListF<NotificationRecord> newNotifications)
    {
        ListF<String> newUniques = initialCount(config, update, newNotifications).counterUniques.getOrElse(Cf.list());
        ListF<String> oldWithoutNew = block.counterUniques.filter(a -> !newUniques.containsTs(a));
        ListF<String> newAndOld = newUniques.plus(oldWithoutNew);

        return update
                .withCount(newAndOld.size())
                .withCounterUniques(newAndOld);
    }
}
