package ru.yandex.chemodan.app.notifier.notification;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.support.RecordField;
import ru.yandex.chemodan.app.notifier.metadata.MetadataWrapper;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author buberman
 */
public class LocalizedMessage extends DefaultObject {
    public final String id;
    public final String message;
    public final MetadataWrapper meta;

    public LocalizedMessage(String id, String message, MetadataWrapper meta) {
        this.id = id;
        this.message = message;
        this.meta = meta;
    }

    public LocalizedMessage(String message) {
        this.id = "";
        this.message = message;
        this.meta = new MetadataWrapper(Cf.hashMap());
    }

    public interface Fields {
        RecordField<String> MESSAGE = RecordField.string("message");
        RecordField<String> META = RecordField.string("meta");
    }

    public static LocalizedMessage fromDataRecord(DataRecord record) {
        String metadataAsString = Fields.META.getO(record).getOrElse("");
        MetadataWrapper metadata;
        if (StringUtils.isNotBlank(metadataAsString)) {
            metadata = MetadataWrapper.fromJsonString(metadataAsString);
        } else {
            metadata = new MetadataWrapper(Cf.hashMap());
        }
        return new LocalizedMessage(record.getRecordId(), Fields.MESSAGE.get(record),
                metadata);
    }

    public MapF<String, DataField> toData() {
        return Cf.toMap(Cf.list(Fields.MESSAGE.toData(message), Fields.META.toData(meta.toJsonString())));
    }
}
